PSCAD 4.2.0

Settings
 {
 Id = "955649630.1144433339"
 Author = "johnn.jayas"
 Desc = "Single-Phase GTO Half-Wave Rectifier"
 Arch = "windows"
 Options = 0
 Build = 18
 Warn = 1
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 0.0005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "ass3.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  freq = 60.0
  }

 }

Definitions
 {
 Module("Main")
  {
  Desc = " "
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Portrait,16,[597,467],100)
   {
   -Wire-([954,144],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.resistor([1080,216],1,0,-1)
    {
    R = "100.0 [ohm]"
    }
   0.ground([1080,288],1,0,-1)
    {
    }
   0.datalabel([72,936],0,0,-1)
    {
    Name = "Vload"
    }
   0.pgb([108,936],0,25994392,100)
    {
    Name = "Vload"
    Group = "Load Voltage"
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-400"
    Max = "400"
    }
   -Wire-([72,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.voltmetergnd([1026,144],0,0,20)
    {
    Name = "Vload"
    }
   0.datalabel([72,972],0,0,-1)
    {
    Name = "Vsource"
    }
   0.pgb([108,972],0,24739600,140)
    {
    Name = "Vsource"
    Group = "Source Voltage"
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-400"
    Max = "400"
    }
   -Wire-([72,972],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.ammeter([1080,180],1,0,30)
    {
    Name = "Iload"
    }
   0.datalabel([72,1008],0,0,-1)
    {
    Name = "Iload"
    }
   0.pgb([108,1008],0,24768976,160)
    {
    Name = "Iload"
    Group = "Load Current"
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.5"
    Max = "3.5"
    }
   -Wire-([72,1008],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.vco([342,612],0,0,50)
    {
    Mode = "1"
    }
   -Wire-([414,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([450,612],2,0,-1)
    {
    Name = "theta"
    }
   -Wire-([954,648],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1008,612],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([270,612],0,0,40)
    {
    Name = ""
    Value = "$(freq)"
    }
   0.annotation([990,468],0,0,-1)
    {
    AL1 = "GTO FIRING PULSE"
    AL2 = "CONTROL CIRCUIT"
    }
   0.peswitch([918,144],5,0,260)
    {
    L = "G"
    Type = "2"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.001 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "50000 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.datalabel([972,108],2,0,-1)
    {
    Name = "FP1"
    }
   0.voltmetergnd([846,144],0,0,10)
    {
    Name = "Vsource"
    }
   0.datalabel([1062,684],0,0,-1)
    {
    Name = "FP1"
    }
   0.annotation([720,162],0,0,-1)
    {
    AL1 = "240 kV, $(freq) Hz"
    AL2 = "AC Source"
    }
   -Wire-([792,216],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.var([918,648],0,24782336,70)
    {
    Name = "Alpha Order"
    Group = "Alpha"
    Display = "0"
    Max = "145"
    Min = "5"
    Value = "94.6"
    Units = "deg"
    Collect = "1"
    }
   -Wire-([792,144],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.source_1([792,252],1,0,250)
    {
    Name = "AC Source"
    Type = "6"
    Grnd = "1"
    Spec = "0"
    Cntrl = "1"
    AC = "0"
    Vm = "240.0 [kV]"
    Tc = "0.01 [s]"
    Ph = "0.0 [deg]"
    f = "60.0 [Hz]"
    P = "0.0 [MW]"
    Q = "0.0 [MVAR]"
    R = "1.0 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    CUR = ""
    }
   0.annotation([1116,216],0,0,-1)
    {
    AL1 = "LOAD"
    AL2 = ""
    }
   -Wire-([1080,144],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([954,108],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1008,612],2,0,-1)
    {
    Name = "theta"
    }
   -Sticky-([774,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 774,522,864,576
    Alignment = 1
    Style = 1
    Arrow = 144
    Color = 0,15792890
    Text = "Alpha ON Slider and Control"
    }
   0.datalabel([198,1044],0,0,-1)
    {
    Name = "FP1"
    }
   0.pgb([234,1062],0,24791976,220)
    {
    Name = "FP1"
    Group = "Firing Pulse"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "1"
    }
   -Wire-([198,1044],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([198,936],0,0,-1)
    {
    Name = "Alpha_ON"
    }
   0.pgb([234,936],0,24795840,110)
    {
    Name = "Alpha ON"
    Group = "Alpha"
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "400"
    }
   -Wire-([198,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([198,1008],0,0,-1)
    {
    Name = "theta"
    }
   0.pgb([234,1008],0,24800088,180)
    {
    Name = "theta"
    Group = "Theta"
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "400"
    }
   -Wire-([198,1008],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1008,648],2,0,-1)
    {
    Name = "Alpha_ON"
    }
   0.fp_int([1062,612],0,0,200)
    {
    Type = "1"
    PNum = "0"
    Blck = "0"
    PFormat = "0"
    detect = "0"
    max = "360.0 [deg]"
    min = "0.0 [deg]"
    BType = "0"
    PTime = "0.005 [s]"
    }
   -Sticky-([702,738],0)
    {
    Name = ""
    Font = 1
    Bounds = 702,738,1134,846
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Interpolated Firing Pulse Generator (GTO)

This component will compare the alpha order in degrees with the output theta, in degrees, from the VCO. The output firing pulse signal is an array of 2 values. The first is a 0 or 1 and  represents the ON/OFF gate pulse to the GTO (0 for OFF and 1 for ON). The second is information regarding the interpolated switching time."
    }
   0.annotation([936,180],0,0,-1)
    {
    AL1 = "HALF-WAVE"
    AL2 = "RECTIFIER"
    }
   0.datatap([234,1062],0,0,210)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Sticky-([828,72],0)
    {
    Name = ""
    Font = 1
    Bounds = 828,72,900,108
    Alignment = 1
    Style = 1
    Arrow = 128
    Color = 0,15792890
    Text = "GTO Component"
    }
   -Wire-([720,252],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1080,252],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.emtconst([378,720],0,0,80)
    {
    Name = ""
    Value = "9"
    }
   0.mult([450,648],0,0,240)
    {
    }
   0.mult([450,720],5,0,230)
    {
    }
   0.const([450,792],3,0,90)
    {
    Name = "RMS Voltage"
    Value = "240.0"
    }
   -Wire-([486,648],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([234,774],0)
    {
    Name = ""
    Font = 1
    Bounds = 234,774,396,828
    Alignment = 1
    Style = 1
    Arrow = 32
    Color = 0,15792890
    Text = "\
Voltage Generation Circuit

(Vpeak = RMS x Sqrt(2))"
    }
   0.datalabel([504,648],2,0,-1)
    {
    Name = "V"
    }
   0.datalabel([720,252],2,0,-1)
    {
    Name = "V"
    }
   0.annotation([720,198],0,0,-1)
    {
    AL1 = "v(t) = V*sin(theta)"
    AL2 = ""
    }
   0.arrow_s([1062,738],2,0,-1)
    {
    }
   0.annotation([360,504],0,0,-1)
    {
    AL1 = "SOURCE VOLTAGE"
    AL2 = "GENERATION"
    }
   0.rms-inst([396,936],0,0,120)
    {
    Type = "0"
    Ts = "0.1 [s]"
    Scale = "1.0"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   -Wire-([324,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([324,936],0,0,-1)
    {
    Name = "Vload"
    }
   0.rms-inst([396,990],0,0,170)
    {
    Type = "0"
    Ts = "0.1 [s]"
    Scale = "1.0"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   -Wire-([324,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([324,990],0,0,-1)
    {
    Name = "Iload"
    }
   -Wire-([432,936],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([432,990],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.pgb([450,936],0,24827640,130)
    {
    Name = "Vrms"
    Group = "Load Voltage"
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "240"
    }
   0.pgb([450,990],0,24830440,190)
    {
    Name = "Irms"
    Group = "Load Current"
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-0.5"
    Max = "3.5"
    }
   -Wire-([972,576],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1008,540],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1008,540],2,0,-1)
    {
    Name = "theta"
    }
   0.datalabel([1008,576],2,0,-1)
    {
    Name = "Alpha_OFF"
    }
   0.datalabel([198,972],0,0,-1)
    {
    Name = "Alpha_OFF"
    }
   0.pgb([234,972],0,24836608,150)
    {
    Name = "Alpha OFF"
    Group = "Alpha"
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "400"
    }
   -Wire-([198,972],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.const([936,576],0,0,60)
    {
    Name = ""
    Value = "150.0"
    }
   -Sticky-([72,72],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,72,612,414
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
The purpose of this example is to illustrate the use of the GTO (Gate Turn-Off Thyristor - part of the \"Power Electronic Switch\" component).

As shown, a simple half-wave, GTO controlled rectifier has been constructed. The voltage source is an externally controlled, dc source, where the control signal is a sinusoid generated by the VCO below. 

The firing pulse control circuit is also shown. It consists of the \"Interpolated Firing Pulse\" component (set to GTO). This block compares two separate high (H) and low (L) inputs - one for the ON pulse and one for the OFF command. When (H) goes higher than (L) in the ON portion, a firing pulse is ordered and the ouput (FP1) goes form 0 to 1. The GTO component consequently fires and continues to conduct until the OFF portion command returns the gate signal from 1 to 0 or until the GTO reaches 0 amps.

In this case, the OFF command is set to 150 degrees. The ON angle can be adjusted manually by a control slider.

This example utilizes \"Interpolated Switching\" - a feature exclusive to EMTDC. If your firing pulse occurs between time steps, EMTDC will interpolate the switching time, allowing for much more accurate results. See the on-line help for more information on Interpolated Switching."
    }
   -Sticky-([72,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 72,18,1152,72
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "GTO CONTROLLED SINGLE-PHASE HALF-WAVE RECTIFIER"
    }
   -ControlPanel-([702,360],0)
    {
    Name = "Control Panel"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 702,360
    Extents = 0,0,216,126
    Slider(24782336)
    Meter(24827640)
    Meter(24830440)
    }
   -Sticky-([72,414],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,414,270,540
    Alignment = 1
    Style = 1
    Arrow = 128
    Color = 0,15792890
    Text = "\
This is the Voltage-Controlled Oscillator (VCO)  component. For an input in Hz, it will output a repeating, 0 to 360 degree ramp function waveform. This waveform is used for reference in the above control circuit.
"
    }
   -Plot-([594,1062],0)
    {
    Title = ""
    Draw = 1
    Area = [0,0,540,504]
    Posn = [594,1062]
    Icon = [594,864]
    Extents = 0,0,540,504
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,540,221],"kV")
     {
     Options = 10
     Units = ""
     Curve(25994392,"Vload",0,,,)
     Curve(24739600,"Vsource",1,,,)
     }
    Graph([0,221],[0,0,540,220],"kA")
     {
     Options = 10
     Units = ""
     Curve(24768976,"Iload",0,,,)
     Curve(24830440,"Irms",1,,,)
     }
    }
   -Plot-([54,1098],0)
    {
    Title = ""
    Draw = 1
    Area = [0,0,504,468]
    Posn = [54,1098]
    Icon = [54,864]
    Extents = 0,0,504,468
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,504,230],"deg")
     {
     Options = 10
     Units = ""
     Curve(24795840,"Alpha ON",0,,,)
     Curve(24800088,"theta",1,,,)
     Curve(24836608,"Alpha OFF",2,,,)
     }
    PGraph([0,230],[0,0,504,175],"PolyGraph")
     {
     Options = 2
     Curve(24791976,"FP1",0,,,1)
     }
    }
   }
  }
 }

